/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.dialog.comp.Measurement;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.util.AnalogValueProperties;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import java.io.IOException;
import java.util.List;

public abstract class Analog
extends ProtectionParameter {
    protected static int MAX_TRIGGER = 20000;
    protected static int MIN_TRIGGER = -20000;
    static final long serialVersionUID = 1L;
    protected transient int fAmplifiedX;
    protected transient AnalogValueProperties fAmplifiedXProperties;
    private int fDecimalPlace = 0;
    protected Measurement fMeasurement = null;
    protected transient int fState = 0;
    protected int fTrigger = 0;
    protected transient double fXInput = 0.0;
    private int serializedDataVersion = 1;

    public Analog() {
    }

    public Analog(Block block) {
        super(block);
    }

    public AnalogValueProperties getAmplifiedXProperties() {
        if (this.fAmplifiedXProperties == null) {
            this.fAmplifiedXProperties = new AnalogValueProperties(MIN_TRIGGER, MAX_TRIGGER, 1, (int)this.fXInput, this.fDecimalPlace, this.isAnalogValueDecimalPlacesAvailable(), "error.dialog.invalidValue", "Invalid Value");
        }
        this.fAmplifiedXProperties.setCurrentValue(this.getMeasurement().getAmplifiedValue((int)this.fXInput));
        this.fAmplifiedXProperties.setDecimalPlace(this.fDecimalPlace);
        return this.fAmplifiedXProperties;
    }

    public int getDecimalPlace() {
        return this.fDecimalPlace;
    }

    public IntValueProperties getDecimalPlaceProperties() {
        return new IntValueProperties(0, 3, 1, this.fDecimalPlace, "error.dialog.invalidValue", "Invalid value");
    }

    public int getGain() {
        return this.getMeasurement().getGain();
    }

    public IntValueProperties getGainProperties() {
        return this.getMeasurement().getGainProperties();
    }

    protected String getGainString() {
        if (this.fMeasurement.getAnalogCalculationMethod().getClass() == Measurement.AnalogCalculation0BA3.class) {
            return Integer.toString(this.getGain());
        }
        return Double.toString((double)this.getGain() / 100.0);
    }

    public Measurement getMeasurement() {
        if (this.fMeasurement == null) {
            this.fMeasurement = new Measurement();
            try {
                if (this.getBlock() != null && this.getBlock().getWiringDiagram() != null && this.getBlock().getWiringDiagram().isUserProgramFromBM) {
                    this.fMeasurement.setSensor(-1, this.getBlock().getHardware());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fMeasurement;
    }

    public int getOffset() {
        return this.getMeasurement().getOffset();
    }

    public IntValueProperties getOffsetProperties() {
        return this.getMeasurement().getOffsetProperties();
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        this.getMeasurement().hardwareChanged(hardwareChangedEvent);
        this.getAmplifiedXProperties().setSuppressLeadingZeroes(this.isAnalogValueDecimalPlacesAvailable());
        this.fireParameterSetEvent();
    }

    public boolean isAnalogValueDecimalPlacesAvailable() {
        return this.getBlock().getHardware().supports("AnalogValueDecimalPlaces");
    }

    public boolean isAvailable(Hardware hw, List errorList) {
        boolean available = super.isAvailable(hw, errorList);
        if (this.getDecimalPlace() > 0 && !hw.supports("AnalogValueDecimalPlaces")) {
            errorList.add(new ErrorInfo(this, "error.convert.analog.decimalPlacesNotSupported", hw));
            available = false;
        }
        if (this.getGain() < 0 && !hw.supports("0BA5AnalogCalculation")) {
            errorList.add(new ErrorInfo(this, "error.convert.measurement.noNegativeGain", hw));
            available = false;
        }
        return available;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fMeasurement = new Measurement();
        this.fMeasurement.read(dr);
        this.fTrigger = dr.readInt();
        this.fDecimalPlace = dr.readInt();
    }

    public void setAmplifiedX(IntValueProperties value) {
        throw new IllegalStateException("The method " + this.getClass().getName() + ".setInput1(IntValueProperties) is not supported");
    }

    public void setDecimalPlace(int decimalPoint) {
        this.fDecimalPlace = decimalPoint;
    }

    public void setDecimalPlaceProperties(IntValueProperties decimalPointProperties) {
        this.fDecimalPlace = decimalPointProperties.getCurrentValue();
    }

    public void setGain(int value) {
        this.getMeasurement().setGain(value);
    }

    public void setGainProperties(IntValueProperties value) {
        this.setGain(value.getCurrentValue());
    }

    public void setOffset(int value) {
        this.getMeasurement().setOffset(value);
    }

    public void setOffsetProperties(IntValueProperties value) {
        this.setOffset(value.getCurrentValue());
    }

    public void setSensorType(int sensorTypeID) {
        this.fMeasurement.setSensor(sensorTypeID, this.getBlock().getWiringDiagram().getHardware());
    }

    public void setTriggerProperties(IntValueProperties value) {
        throw new IllegalStateException("The method " + this.getClass().getName() + ".setTriggerProperties(IntValueProperties) is not supported");
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        this.getMeasurement().write(dw);
        dw.writeInt(this.fTrigger);
        dw.writeInt(this.fDecimalPlace);
    }
}

